clear all
%Model preliminaries 
ngrid=501;
c_upper=zeros(1,ngrid);
c_lower=zeros(1,ngrid);
c_lower_g=zeros(1,ngrid);
Delta=0.2; 
Rd=1.04;
P=1.20;
gamma=1.2; 
omega=0.0001;

%%
%An economy without guarantors 

%Solve phi_star 
%Parameterization 1 
pi_fun=@(x)(x-(1+1/gamma)*(omega*gamma)^(1/(gamma+1))*x^(gamma/(gamma+1))+omega-Rd);
phi_grid=linspace(0,5,ngrid);
pi_grid=zeros(1,ngrid);
x=linspace(0,1,ngrid);
for i=1:ngrid
    pi_grid(i)=pi_fun(phi_grid(i));
end 

figure 
plot(phi_grid,pi_grid)
[zpc,index]=min(abs(pi_grid));
phi_star=phi_grid(index); 

if phi_star>P || phi_star<omega*gamma 
    error('phi_star is out of range') 
end 

%%
%Introducing guarantors into the economy 
%Additional parameters 
omega_g=8e-7;
c_g=0.01;

%Solve phi_g_star
pi_fun_g=@(x)(x-(1+1/gamma)*(omega_g*gamma)^(1/(gamma+1))*x^(gamma/(gamma+1))+omega_g-c_g);
phi_grid=linspace(0,5,ngrid);
pi_grid=zeros(1,ngrid);
for i=1:ngrid
    pi_grid(i)=pi_fun_g(phi_grid(i));
end 

figure 
plot(phi_grid,pi_grid)
[zpc,index]=min(abs(pi_grid));
phi_g_star=phi_grid(index);
phi_g_star

%Check Assumption 1 
if phi_g_star+Rd > phi_star 
    error('Assumption 1 violated: c_g too high')
end 

for i=1:ngrid
    if x(i)<Delta 
        xhat=0.5*(x(i)+Delta);
    elseif x(i)>1-Delta 
        xhat=0.5*(1+x(i)-Delta); 
    else 
        xhat=x(i);
    end 
    
    c_upper(i)=max((Rd-P*(1-xhat))/xhat,0);
    xhhat=max(x(i)-Delta,0);
    c_lower(i)=max((phi_star-P*(1-xhhat))/xhhat,0);
    c_lower_g(i)=max((Rd+phi_g_star-P*(1-xhhat))/xhhat,0);
end 


%%
% plot
sky_blue = [135 206 250]./255;
light_grey = [211 211 211]./255;
light_pink = [255 192 203]./255;

figure 
h1 = plot(x,c_upper,'k-', 'LineWidth', 1.5);
hold on;
h2 = plot(x,c_lower,'r-.', 'LineWidth', 1.5);
hold on;
h3 = plot(x,c_lower_g,'r--', 'LineWidth', 1.5);
xlabel('Balance sheet signal x', 'FontSize', 14)
ylabel('Collateral c', 'FontSize', 14)
title('', 'Interpreter', 'latex', 'FontSize', 14)


xxx=x(c_upper>c_lower);  yyy_up = c_upper(c_upper>c_lower); yyy_down = c_lower(c_upper>c_lower);
h4 = fill([xxx, fliplr(xxx)], [yyy_up,  fliplr(yyy_down)], sky_blue, 'EdgeColor', 'none'); hold on; alpha(0.4);

xxx2=x(c_upper>c_lower_g);  yyy_up2 = c_upper(c_upper>c_lower_g); yyy_down2 = c_lower_g(c_upper>c_lower_g);
h5 = fill([xxx2, fliplr(xxx2)], [yyy_up2,  fliplr(yyy_down2)], light_grey, 'EdgeColor', 'none'); hold on; alpha(0.4);

legend([h1 h2 h3 h4 h5], '$\bar{c}$','$\underline{c}: \omega=.0001$','$\underline{c}_g: \omega_g=8e-7, c_o=.01$',...
    'Projects funded (guarantor-less economy)', ...
    'Additional projects funded (guarantor economy)', 'Interpreter','latex','Location','southeast', 'FontSize', 12);
%set(h,'Interpreter','latex','Location','southwest')

set(gcf, 'Position', [10 10 800 600]);
saveas(gcf, './effect_guarantor.eps', 'epsc')

%Optimal effort 
e_star=(phi_star/(omega*gamma))^(1/(gamma+1))-1;
Fe_star=e_star/(e_star+1); 
e_g_star=(phi_g_star/(omega_g*gamma))^(1/(gamma+1))-1;
Fe_g_star=e_g_star/(e_g_star+1); 







